/* Abelbeck Aviation Checklist - main menu module script
Copyright 2024 Frank Abelbeck <frank@abelbeck.info>

This file is part of the Abelbeck Aviation Checklist (AAC) toolbox.

The AAC toolbox is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

The AAC toolbox is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the AAC toolbox.  If not, see <http://www.gnu.org/licenses/>.
*/

import {
	AacWebDocumentManager
} from "./libAAC.js";


export class MainMenu extends AacWebDocumentManager {
	
	constructor(mapMeta) {
		super(mapMeta);
	}
	
	async runMain() {
		/*
		 * construct main menu:
		 * 
		 *  - create nav element and populate it with anchors to the checklists
		 *  - create simple page with header, main, and footer and replace the current document body
		 *  - set main stylesheet 
		 */
		document.body.replaceChildren(
			this.constructStandardHeader("Abelbeck Aviation Checklist Toolbox"),
			AacWebDocumentManager.constructNode("main",
				AacWebDocumentManager.constructNode("nav",[
					AacWebDocumentManager.constructNode("a","Checklists...", { href:"./checklist.html" }),
					AacWebDocumentManager.constructNode("a","GPL 3 license text...", { href:"./COPYING.html" }),
				]),
			),
			this.constructStandardFooter()
		);
		this.setStyleSheet("css/main.css");
	}
}
