/* Abelbeck Aviation Checklist - derived web document class script
Copyright 2024 Frank Abelbeck <frank@abelbeck.info>

This file is part of the Abelbeck Aviation Checklist (AAC) toolbox.

The AAC toolbox is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

The AAC toolbox is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the AAC toolbox.  If not, see <http://www.gnu.org/licenses/>.
*/

import {
	WebDocumentManager
} from "./libWebDoc.js";


export class AacWebDocumentManager extends WebDocumentManager {
	
	async updateStateMain() {
		// process .dark query parameter
		if (this._urlState.searchParams.has(".dark")) {
			document.documentElement.classList.add("dark");
		} else {
			document.documentElement.classList.remove("dark");
		}
	}
	
	interceptExternalAnchorClick(event,urlTarget) {
		try {
			navigator.vibrate(100);
		} catch (err) {}
		
		if (urlTarget.origin === document.location.origin) {
			// pass .dark query param (if defined) to all documents on this host
			if (this._urlState.searchParams.has(".dark")) urlTarget.searchParams.set(".dark","");
		}
		super.interceptExternalAnchorClick(event,urlTarget);
	}
	
	interceptInternalAnchorClick(event,urlTarget) {
		try {
			navigator.vibrate(100);
		} catch (err) {}
		
		if (urlTarget.origin === document.location.origin) {
			// pass .dark query param (if defined) to all documents on this host
			if (this._urlState.searchParams.has(".dark")) urlTarget.searchParams.set(".dark","");
		}
		super.interceptInternalAnchorClick(event,urlTarget);
	}
	
	toggleDarkMode(boolUpdateUrl=true) {
		document.documentElement.classList.toggle("dark");
		if (document.documentElement.classList.contains("dark")) {
			this._urlState.searchParams.set(".dark","");
		} else {
			this._urlState.searchParams.delete(".dark");
		}
		if (boolUpdateUrl) this.updateUrl();
	}
	
	constructStandardHeader(strHeading) {
		return WebDocumentManager.constructNode("header",[
			WebDocumentManager.constructNode("h4",strHeading),
		]);
	}
	
	constructStandardFooter() {
		return WebDocumentManager.constructNode("footer",[
			WebDocumentManager.constructNode("span",[
				WebDocumentManager.constructText("Copyright 2024 "),
				WebDocumentManager.constructNode("a","Frank Abelbeck", { href:"mailto:frank@abelbeck.info" })
			]),
			WebDocumentManager.constructButton("THEME", () => { this.toggleDarkMode(); }, { id:"btnTheme" }),
		]);
	}
	
	setStyleSheet(strFilename) {
		try { document.getElementById(aacMainStyleSheet).setAttribute("href",strFilename); } catch (err) {}
	}
	
	processAnchors() {
		super.processAnchors();
	}
	
}
